﻿using System;
using System.Collections.Generic;

namespace Ato.CD.Inbound.Shared
{
    public static class CrossFormExtensions
    {
        public static List<Context> AddContext(this List<Context> contexts, DateTime? startDate, DateTime? endDate, int index, string id)
        {
            if (index > 0)
                contexts.Add(new Context
                {
                    StartDate = startDate,
                    EndDate = endDate,
                    Index = index,
                    Id = id
                });

            return contexts;
        }

        public struct Context
        {
            public DateTime? StartDate { get; set; }
            public DateTime? EndDate { get; set; }
            public int Index { get; set; }
            public string Id { get; set; }
        }
    }
}